<!DOCTYPE html>
<html lang="en">
<head>
<title> Responsive</title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="author" content="html.design">
<!-- description -->
<meta name="description" content="Wizard Form with Validation - Responsive">
<meta name="csrf-token" content="{{ csrf_token() }}" />
{{-- <link rel="shortcut icon" href="images/favicon.ico"> --}}
<!-- Bootstrap CSS -->
<link rel="stylesheet" href="{{ asset('wizard/css/bootstrap.min.css') }}">
<!-- Fontawesome CSS -->
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.9/css/all.css">
<!-- Fonts and icons -->
<link href="https://fonts.googleapis.com/css?family=Montserrat:100,200,300,400,500,600,700" rel="stylesheet"> 
<!-- Reset CSS -->
{{-- <link rel="stylesheet" href="{{ asset('wizard/css/reset.css') }}"> --}}
{{-- toastr css --}}
<link href="{{ asset('bootstrap/css/toastr.min.css') }}" rel="stylesheet" />
<!-- Style CSS -->
<link rel="stylesheet" href="{{ asset('wizard/css/style.css') }}">
<link rel="stylesheet" href="{{ asset('css/styles.css') }}">
<!-- Responsive  CSS -->
<link rel="stylesheet" href="{{ asset('wizard/css/responsive.css') }}">
{{-- JQuery js --}}
{{-- toastr js --}}
<script src="{{ asset('bootstrap/js/jquery.js') }}"></script>
<script src="{{ asset('bootstrap/js/toastr.min.js') }}"></script>
{{-- Phone number with country code --}}
<link href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.3/css/intlTelInput.min.css" rel="stylesheet"/>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.3/js/intlTelInput.min.js"></script>
</head>
<body>

<div class="wizard-main">
	<div id="particles-js"></div>
	<div class="container">
		<div class="row">
			<div class="col-lg-12">
				<h2 class="title-wb">User Login Form</h2>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-6 banner-sec">
				<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
					{{-- <ol class="carousel-indicators">
						<li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
						<li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
						<li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
					</ol> --}}
					<div class="carousel-inner" role="listbox">
					{{-- <div class="carousel-item active">
							<img class="d-block img-fluid" src="{{ asset('wizard/images/slider1.png') }}" alt="First slide">
							<div class="carousel-caption d-none d-md-block">
								<div class="banner-text">
									<h2>Wheels2Door</h2>
									<p>We are a start-up committed to solve the problem of unemployment in our country by creating millions of Delivery resource jobs over a period of time, for male, female and third gender individuals.</p>
								</div>	
							</div>
						</div> --}}<br>
						<div class="carousel active"><br><br><br><br><br><br>
							<img class="d-block img-fluid" src="https://bncmc.gov.in/wp-content/uploads/2019/07/bncmc.png" alt="First slide">
							<div class="carousel-caption d-none d-md-block">
								<div class="banner-text">
									<!-- <h2>Wheels2Door</h2>
									<p>We are a start-up committed to solve the problem of unemployment in our country by creating millions of Delivery resource jobs over a period of time, for male, female and third gender individuals.</p> -->
								</div>	
							</div>
						</div>
					{{-- <div class="carousel-item">
							<img class="d-block img-fluid" src="{{ asset('wizard/images/slider3.png') }}" alt="First slide">
							<div class="carousel-caption d-none d-md-block">
								<div class="banner-text">
									<h2>Wheels2Door</h2>
									<p>We are a start-up committed to solve the problem of unemployment in our country by creating millions of Delivery resource jobs over a period of time, for male, female and third gender individuals.</p>
								</div>	
							</div>
						</div>--}}
					</div>	   
				</div>
			</div>
			<div class="col-lg-6 login-sec">
				<div class="login-sec-bg">
					<h2 class="text-center">Personal Information</h2>
					<form action="{{ url('/login_front') }}" method="POST">
						@csrf
                        <h3 class="text-center p-2">Login</h3>
						<fieldset class="form-input">
							@if ($errors->any())
							<div class="alert alert-danger">
							@foreach ($errors->all() as $error)
									{{ $error }}
							@endforeach
							</div>
							@endif

							@if (session('success'))
							<div class="alert alert-success">
								{{ session('success') }}
							</div>
							@endif

							@if (session('error'))
							<div class="alert alert-danger">
								{{ session('error') }}
							</div>
							@endif
                            
			                <h4>Aadhar Card</h4>
							<input type="text"  name="aadhar_number" id="aadhar_number"  class="form-control" placeholder="Must be a 12-digit number.">
							<h4>Full Name</h4>
							<input type="text"  name="full_name" id="full_name" style="pointer-events: none;" class="form-control">
							<h4>Phone Number</h4>
			                <input type="number" name="phone_number" id="phone_number" style="pointer-events: none;"  class="form-control required"  pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==10) return false;" style="" />
                             <br>
							 <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
							  Video Recording
							</button> 

<!-- Modal -->
 <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" style="max-width: 90%;" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h4>Random No</h4>
        <input type="text"  name="randomNo" id="randomNo" class="form-control" readonly><br>
          <div class="row">
	            <div class="col-md-6">
	                    <h2>Preview</h2>
	                    <video id="preview" width="500" height="400" autoplay muted></video><br/><br/>
	                    <div class="btn-group">
	                        <div id="startButton" class="btn btn-success"> Start </div>
	                        <div id="stopButton" class="btn btn-danger"  style="display:none;"> Stop </div>
	                        <a id="retakeButton" class="btn btn-info" style="display: none;">Retake</a>
	                    </div>
	            </div>
	            <div class="col-md-6" id="recorded"  style="display:none">
	                    <h2>Recording</h2><br>
	                    <video id="recording" width="450" height="350" controls></video><br/><br/>
	                    <a id="downloadButton" class="btn btn-primary" data-url="">save</a>
	                    <a id="downloadLocalButton" class="btn btn-primary">Download</a>
	            </div>
           </div>
	    </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
	        <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
	      </div>
	    </div>
	  </div>
	</div> 
<!-- Modal -->


                        <button class="btn btn-warning mt-3 form-control">SEND OTP</button>
						</fieldset>
					</form>	
          <!--   <script>
                var phone_number = window.intlTelInput(document.querySelector("#phone_number"), {
                separateDialCode: false,
                preferredCountries:["in"],
                hiddenInput: "full",
                utilsScript: "http://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.3/js/utils.js"
              });
                        
              $("form").submit(function() {
                var full_number = phone_number.getNumber(intlTelInputUtils.numberFormat.E164);
              $("input[name='phone_number[full]'").val(full_number);
                          
              });
            </script>		 -->
				</div>
			</div>			
		</div>
		<div class="row">
			<div class="col-lg-12">
				<p class="copyright text-center">All Rights Reserved. &copy; Copyright 2023 <a href="#"></a></p>
			</div>
		</div>
	</div>
</div>

</body>
</html>

<!-- jquery latest version -->
<script src="{{ asset('wizard/js/jquery.min.js') }}"></script>
<!-- popper.min.js -->
<script src="{{ asset('wizard/js/popper.min.js') }}"></script>    
<!-- bootstrap js -->
<script src="{{ asset('wizard/js/bootstrap.min.js') }}"></script>
<!-- jquery.steps js -->
<script src='https://ajax.aspnetcdn.com/ajax/jquery.validate/1.15.0/jquery.validate.js'></script>
<script src="{{ asset('wizard/js/jquery.steps.js') }}"></script>
<!-- particles js -->
<script src="{{ asset('wizard/js/particles.js') }}"></script>

<script>

// Function to generate a random number
  function generateRandomNumber() {
    return Math.floor(Math.random() * 1000); // Change the range as needed
  }

  // Get the input element by its ID
  var randomNoInput = document.getElementById("randomNo");

  // Set the input field's value to the generated random number
  randomNoInput.value = generateRandomNumber();


$(document).ready(function () {
        $('#aadhar_number').on('change', function () {
            var aadharNumber = $(this).val();
            if (aadharNumber) {
                $.ajax({
                    url: '{{ route("get-user-data") }}', 
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        _token: $('meta[name="csrf-token"]').attr('content'), // Include CSRF token in data
                        aadhar_number: aadharNumber
                    },
                    success: function (data) {
                        $('#full_name').val(data.full_name);
                        $('#phone_number').val(data.phone_number);
                    },
                    error: function () {
                        console.log('Error fetching user data');
                    }
                });
            }
        });
    });

  //alert message
var successMessage = $(".alert-success,.alert-danger");
if (successMessage.length) {
    successMessage.fadeIn();
    setTimeout(function () {
        successMessage.fadeOut();
    }, 3000); // 3000 milliseconds = 3 seconds
}


$(document).ready(function () {
     navigator.mediaDevices.getUserMedia({
        video: true,
        audio: false
    })
    let preview = document.getElementById("preview");
    let recording = document.getElementById("recording");
    let startButton = document.getElementById("startButton");
    let stopButton = document.getElementById("stopButton");
    let retakeButton = document.getElementById("retakeButton"); // New Retake button
    let downloadButton = document.getElementById("downloadButton");
    let logElement = document.getElementById("log");
    let recorded = document.getElementById("recorded");
    let downloadLocalButton = document.getElementById("downloadLocalButton");

    let recordingTimeMS = 9000; // Video limit 60 seconds
    var localstream;
    var mediaRecorder;
    var recordedChunks = [];

    window.log = function (msg) {
        console.log(msg);
    }

    window.wait = function (delayInMS) {
        return new Promise(resolve => setTimeout(resolve, delayInMS));
    }

    window.startRecording = function (stream, lengthInMS) {
        mediaRecorder = new MediaRecorder(stream);
        recordedChunks = [];

        mediaRecorder.ondataavailable = event => {
            if (event.data.size > 0) {
                recordedChunks.push(event.data);
            }
        };

        mediaRecorder.start();
        log(mediaRecorder.state + " for " + (lengthInMS / 1000) + " seconds...");

        let stopped = new Promise((resolve, reject) => {
            mediaRecorder.onstop = resolve;
            mediaRecorder.onerror = event => reject(event.name);
        });

        let recorded = wait(lengthInMS).then(
            () => mediaRecorder.state == "recording" && mediaRecorder.stop()
        );

        return Promise.all([
            stopped,
            recorded
        ])
            .then(() => recordedChunks);
    }

    var formData = new FormData();

    if (startButton) {
        startButton.addEventListener("click", function () {
            startButton.innerHTML = "Recording...";
            recorded.style.display = "none";
            stopButton.style.display = "inline-block";
            // downloadButton.innerHTML = "Please wait some time...";
            downloadButton.style.display = "none";

            // Include audio constraint to capture audio
            navigator.mediaDevices.getUserMedia({
                video: true,
                audio: true // Enable audio recording
            }).then(stream => {
                preview.srcObject = stream;
                localstream = stream;
                preview.captureStream = preview.captureStream || preview.mozCaptureStream;
                return new Promise(resolve => preview.onplaying = resolve);
            }).then(() => startRecording(preview.captureStream(), recordingTimeMS))
                .then(recordedChunks => {
                    let recordedBlob = new Blob(recordedChunks, {
                        type: "video/webm"
                    });
                    recording.src = URL.createObjectURL(recordedBlob);

                    formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
                    formData.append('video', recordedBlob);

                    downloadLocalButton.href = recording.src;
                    downloadLocalButton.download = "RecordedVideo.webm";
                    log("Successfully recorded " + recordedBlob.size + " bytes of " +
                        recordedBlob.type + " media.");
                    startButton.innerHTML = "Start";
                    stopButton.style.display = "none";
                    recorded.style.display = "block";
                    // downloadButton.innerHTML = "Save";
                })
                .catch(log);
        }, false);
    }

    if (stopButton) {
        stopButton.addEventListener("click", function () {
            mediaRecorder.stop();
            localstream.getTracks().forEach(track => track.stop());
            startButton.style.display = "none";
            stopButton.style.display = "none";
            recorded.style.display = "block";
            downloadButton.style.display = "inline-block";
            retakeButton.style.display = "inline-block"; // Display the Retake button
        }, false);
    }

    if (retakeButton) {
        retakeButton.addEventListener("click", function () {
            // Hide the Retake button and reset the UI
            startButton.innerHTML = "Start again...";
            retakeButton.style.display = "none";
            startButton.style.display = "inline-block";
            recorded.style.display = "none";
            downloadButton.style.display = "none";
            recording.src = ""; // Clear the recorded video
        }, false);
    }

    if (downloadButton) {
        downloadButton.addEventListener("click", function () {
            $.ajax({
                url: this.getAttribute('data-url'),
                method: 'POST',
                data: formData,
                cache: false,
                processData: false,
                contentType: false,
                success: function (res) {
                    if (res.success) {
                        location.reload();
                    }
                }
            });
        }, false);
    }

     // -- save
    if (downloadButton) {
        downloadButton.addEventListener("click", function () {

         // var adharNo = document.getElementById("adharNoInput").value; 
         // var randomNumber = document.getElementById("randomNumber").value; 
         // formData.append('adharNo', adharNo);
         // formData.append('randomNumber', randomNumber);

            $.ajax({
                url: '{{ route('saveVideo') }}', // Use the named route
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: formData,
                cache: false,
                processData: false,
                contentType: false,
                success: function (res) {
                    if (res.success) {
                        alert('Video saved successfully.'); // Display a success message
                        // location.reload(); // Reload the page or perform a redirect
                        $('#recorded').hide();
                        $('#exampleModal').modal('hide'); // Assuming your modal's ID is "myModal"


                    }
                }
            });
        }, false);
    }
    //--save close

});
</script>

