<?php $__env->startSection('title'); ?>
Profile
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    .btn {
    margin-right: 8px; /* Adjust the spacing as needed */
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="p-0">
        <div class="card">
            <div class="card-header ui-sortable-handle" style="cursor: move;">
                <h3 class="card-title"><i class="fas fa-users mr-1"></i>
                    Personal Detail
                </h3>
                <div class="card-tools">
                    <ul class="nav nav-pills ml-auto">
                        <li class="nav-item mr-1">
                            <a href="<?php echo e(route('personaldetail.create')); ?>" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle"></i> Add New</a>
                        </li>
                    </ul>
                </div>
            </div><!-- /.card-header -->
            
            <div class="card-body table-responsive table-bordered">
                <table class="table" id="example">
                    <thead>
                        <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Mobile No</th>
                        <th>Status</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $personaldetail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($detail->first_name .' '.$detail->last_name); ?> </td>
                            <td><?php echo e($detail->email); ?></td>
                            <td><?php echo e($detail->mobile_no); ?></td>
                            <td>
                                  <?php if($detail->status == 1): ?>
                                   <span class="badge badge-success"> <?php echo e('Verify'); ?> <span>  
                                  <?php elseif($detail->status == 2): ?>
                                   <span class="badge badge-danger">  <?php echo e('Reject'); ?> <span>  
                                  <?php else: ?>
                                   <span class="badge badge-secondary">  <?php echo e('New'); ?> <span>  
                                  <?php endif; ?>
                            </td>
                            <td>
                            <div class="btn-group">
                                <a href="<?php echo e(route('personaldetail.show',$detail->id)); ?>" title="Show" class="btn btn-flat btn-sm btn-info" > <i class="fa fa-eye"></i>  </a>
                                <a href="<?php echo e(route('personaldetail.edit',$detail->id)); ?>" title="Edit" class="btn btn-flat btn-sm btn-warning" > <i class="fa fa-edit"></i> </a>
                                 <form action="<?php echo e(route('personaldetail.destroy',$detail->id)); ?>" method="POST" onclick="return confirm(' Are you sure you want to Delete?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?> 
                                   <button class="btn btn-flat btn-sm btn-danger" title="Delete" > <i class="fas fa-trash-alt"></i>  </button>
                            </div>
                                </form>
                            </td>
                        </tr>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </tbody>
                </table>
            </div>
            
            
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script>
    $(document).ready(function () {
        $('#example').DataTable(); // Replace 'example' with the ID of your table
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kart/retirement.creatorkart.com/retirement/resources/views/persoanldetail/index.blade.php ENDPATH**/ ?>