<?php

namespace App\Http\Controllers\front;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\PersonalDetail;

class homeController extends Controller
{
    public function index(){
     
        return view('pages.home');
    }


  public function getUserData(Request $request)
    {
        $aadharNumber = $request->input('aadhar_number');
      
        $user = PersonalDetail::where('aadhaar_no', $aadharNumber)->first();
        if ($user) {
            return response()->json([
                'full_name' => $user->first_name .' '.$user->middle_name.' '.$user->last_name,
                'phone_number' => $user->mobile_no,
                'date_of_birth' => $user->date_of_birth,
                'retirement_date' => $user->retirement_date,
            ]);
        } else {
            return response()->json(['error' => 'User not found']);
        }
    }



   public function login_front(Request $request)
{
    try {
        $request->validate(
            [
                'aadhar_number' => ['required', 'numeric', 'digits:12'],
            ],
            [
                'aadhar_number.required' => 'The Aadhar number is required',
                'aadhar_number.numeric' => 'The Aadhar number must be numeric',
                'aadhar_number.digits' => 'The Aadhar number must be exactly :digits digits',
            ]
        );

        $key = "kbf8IN83hIxNTVgs";
        $phone = $request->phone_number;
        $otp = rand(10, 10000);
        $message_content = urlencode("Your Current OTP Is {$otp} CoreOC");
        $senderid = "CoreOC";
        $route = 1;
        $url = "http://sms.adityahost.com/vb/apikey.php?apikey=$key&senderid=$senderid&number=$phone&message=$message_content";
        $output = file_get_contents($url);
        
        PersonalDetail::where('mobile_no', $phone)->update(['otp' => $otp]);

        return redirect('view_otp')->with('phone', $phone)->with('success', 'OTP is sent to your Mobile number!');
    } catch (Exception $e) {
        return back()->with('error', 'An error occurred: ' . $e->getMessage());
    }
}




      public function viewOTP(Request $request)
    {
        $phone = session('phone');
        return view('pages.otp',compact('phone'));
    }



	public function verifyOTP(Request $request)
	{
	    try {
	        $request->validate([
	            'otp' => 'required|numeric',
	        ]);

	        $response = PersonalDetail::where('otp', $request->otp)->first();

	        if ($response) {
	            return redirect('/')->with('success', 'Registration Successful!!!');
	        } else {
	            return back()->with('error', 'Invalid OTP');
	        }
	    } catch (Exception $e) {
	        return back()->with('error', 'An error occurred: ' . $e->getMessage());
	    }
	}
	
	
	   public function saveVideo(Request $request)
{
    // $request->validate([
    //     'adhar_no' => 'required',
    //     'video' => 'required|file|mimes:mp4,avi,mov', // Adjust allowed video formats
    // ]);

    if ($request->hasFile('video')) {
        $personalDetail = PersonalDetail::where('aadhaar_no', '123456789000')->first();
        $video = $request->file('video');
        $extension=$video->getClientOriginalName();
        $filename= time() .'.'.$extension;
        $video->move('uploads/', $filename);
        $personalDetail->live_video = $filename;
        $personalDetail->save();
        return response()->json(['success' => true]);

    }else {
        return response()->json(['success' => false]);
    }

}






}






