@extends('includes.master')


@section('content')

<div class="wizard-main">
	<div id="particles-js"></div>
	<div class="container">
		<div class="row">
		
			<div class="col-lg-6 login-sec mx-auto">
				<div class="login-sec-bg">
					<h2 class="text-center">Personal Information</h2>
					<form action="{{ url('/login_front') }}" method="POST">
						@csrf
                        <h3 class="text-center p-2">Login</h3>
						<fieldset class="form-input">
                            @include('includes.alerts')
                            
			                <h4>Aadhaar Number</h4>
							<input type="text"  name="aadhar_number" id="aadhar_number"  class="form-control" placeholder="Must be a 12-digit number.">
							<h4>Full Name</h4>
							<input type="text"  name="full_name" id="full_name" style="pointer-events: none;" class="form-control">
							<h4>Phone Number</h4>
			                <input type="number" name="phone_number" id="phone_number" style="pointer-events: none;"  class="form-control required"  pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==10) return false;" style="" />
                            
                            <h4>Date of Birth</h4>
			                <input type="date" name="date_of_birth" id="date_of_birth" style="pointer-events: none;"  class="form-control required" style="" />
    
                             <h4>Date of Retirement</h4>
			                <input type="date" name="retirement_date" id="retirement_date" style="pointer-events: none;"  class="form-control required"  style="" />
                             <br>

	                        <div class="row">
	                         <div class="col-lg-6">
	                              <button class="btn btn-warning mt-3 form-control">Verify</button>
	                         </div>
	                         <div class="col-lg-6">
	                              <a href="#" class="btn btn-warning mt-3 form-control">Cancel</a>
	                         </div>
	                        </div>
	                       
						</fieldset>
					</form>	
				</div>
			</div>			
		</div>
	</div>
</div>


@endsection
@section('js')
<script src="{{ asset('wizard/js/jquery.min.js') }}"></script>

<script>
$(document).ready(function () {
        $('#aadhar_number').on('change', function () {
            var aadharNumber = $(this).val();
            if (aadharNumber) {
                $.ajax({
                    url: '{{ route("get-user-data") }}', 
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        _token: $('meta[name="csrf-token"]').attr('content'), // Include CSRF token in data
                        aadhar_number: aadharNumber
                    },
                    success: function (data) {
                        $('#full_name').val(data.full_name);
                        $('#phone_number').val(data.phone_number);
                        $('#date_of_birth').val(data.date_of_birth);
                        $('#retirement_date').val(data.retirement_date);
                    },
                    error: function () {
                        console.log('Error fetching user data');
                    }
                });
            }
        });
    });

  //alert message
var successMessage = $(".alert-success,.alert-danger");
if (successMessage.length) {
    successMessage.fadeIn();
    setTimeout(function () {
        successMessage.fadeOut();
    }, 3000); // 3000 milliseconds = 3 seconds
}

</script>
@endsection

