<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PersonalDetailController;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect(route('login'));
});

Auth::routes();

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('welcome/',[App\Http\Controllers\front\homeController::class,'welcome']);
Route::get('/front',[App\Http\Controllers\front\homeController::class,'index']);
Route::post('/login_front', [App\Http\Controllers\front\homeController::class,'login_front']);
Route::post('/get-user-data', 'App\Http\Controllers\front\homeController@getUserData')->name('get-user-data');
Route::get('/view_otp', [App\Http\Controllers\front\homeController::class,'viewOTP'])->name('view_otp');
Route::post('/verify-otp', [App\Http\Controllers\front\homeController::class,'verifyOTP'])->name('verify-otp');

// Route::get('/recording-video', [App\Http\Controllers\front\homeController::class,'recordingVideo'])->name('recording-video');
Route::match(['get', 'post'], 'recordings-video', 'App\Http\Controllers\front\homeController@recordingVideo');

Route::post('/save-video', [App\Http\Controllers\front\homeController::class, 'saveVideo'])->name('saveVideo');
Route::get('/preview-video', [App\Http\Controllers\front\homeController::class,'previewVideo'])->name('preview-video');
Route::get('/get-video-data', [App\Http\Controllers\front\homeController::class,'getVideoData'])->name('getVideoData');

Route::get('exportExcels', [PersonalDetailController::class, 'exportUsers'])->name('exportUsers');

Route::group(['middleware' => 'auth'], function() {
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

    Route::resource('user', 'App\Http\Controllers\UserController');

    Route::resource('permission', 'PermissionController');

    Route::get('/profile', 'App\Http\Controllers\UserController@profile')->name('user.profile');

    Route::post('/profile', 'App\Http\Controllers\UserController@postProfile')->name('user.postProfile');

    Route::get('/password/change', 'App\Http\Controllers\UserController@getPassword')->name('userGetPassword');

    Route::post('/password/change', 'App\Http\Controllers\UserController@postPassword')->name('userPostPassword');

    Route::resource('personaldetail', 'App\Http\Controllers\PersonalDetailController');
    Route::resource('documenttype','App\Http\Controllers\DocumentTypeController');
   
    Route::post('/records/{id}', [App\Http\Controllers\PersonalDetailController::class,'RejectApplication'])->name('RejectApplication');


});


Route::get('/search/user', 'UserController@search');

