<?php

namespace App\Http\Controllers\front;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\PersonalDetail;
use File;
class homeController extends Controller
{

  public function welcome()
   {
     return view('pages.welcome');
   }

  public function index()
   {
     return view('pages.home');
   }


  public function getUserData(Request $request)
    {
        $aadharNumber = $request->input('aadhar_number');
      
        $user = PersonalDetail::where('aadhaar_no', $aadharNumber)->first();
        if ($user) {
            return response()->json([
                'full_name' => $user->first_name .' '.$user->middle_name.' '.$user->last_name,
                'phone_number' => $user->mobile_no,
                'date_of_birth' => $user->date_of_birth,
                'retirement_date' => $user->retirement_date,
            ]);
        } else {
            return response()->json(['error' => 'User not found']);
        }
    }


   public function login_front(Request $request)
   {
        try {
            $request->validate(
                [
                    'aadhar_number' => ['required', 'numeric', 'digits:12'],
                ],
                [
                    'aadhar_number.required' => 'The Aadhar number is required',
                    'aadhar_number.numeric' => 'The Aadhar number must be numeric',
                    'aadhar_number.digits' => 'The Aadhar number must be exactly :digits digits',
                ]
            );
           
           $aadhaar_check=DB::table('personal_detail')
               ->select('aadhaar_no')->where('aadhaar_no',$request->aadhar_number)->first();

            if ($aadhaar_check) {
                $key = "kbf8IN83hIxNTVgs";
                $phone = $request->phone_number;
                $otp = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);

                // $message_content = urlencode("Your Current OTP Is {$otp} CoreOC");
                // $senderid = "CoreOC";
                // $route = 1;
                // $url = "http://sms.adityahost.com/vb/apikey.php?apikey=$key&senderid=$senderid&number=$phone&message=$message_content";
                // $output = file_get_contents($url);
                
                PersonalDetail::where('mobile_no', $phone)->update(['otp' => $otp]);
                $request->session()->put('aadhaar_no', $request->aadhar_number);

                return redirect('view_otp')->with('success', 'OTP is sent to your Mobile number!');

            } else {
                return back()->with('error', 'Aadhaar not found in our records.');
            }

            

        } catch (Exception $e) {
            return back()->with('error', 'An error occurred: ' . $e->getMessage());
        }
   }


  public function viewOTP(Request $request)
    {
        $aadharNumber = $request->session()->get('aadhaar_no');
        $user = DB::table('personal_detail')->where('aadhaar_no', $aadharNumber)->first();
        return view('pages.otp',compact('aadharNumber','user'));
    }


  public function verifyOTP(Request $request)
	{
	    try {
	        $request->validate([
	            'otp' => 'required|numeric',
	        ]);

	        $response = PersonalDetail::where('otp', $request->otp)->first();

	        if ($response) {
               $request->session()->put('aadhaar_no', $request->aadhaar_no);
	            return redirect('recordings-video');
	        } else {
	            return back()->with('error', 'Invalid OTP');
	        }
	    } catch (Exception $e) {
	        return back()->with('error', 'An error occurred: ' . $e->getMessage());
	    }
	}


  public function recordingVideo(Request $request)
    {
        $aadharNumber = $request->session()->get('aadhaar_no');
        $user = DB::table('personal_detail')->where('aadhaar_no', $aadharNumber)->first();
        return view('pages.recordings',compact('aadharNumber','user'));
    }


 public function saveVideo(Request $request)
  {
        try {
    
            $personalDetail = PersonalDetail::where('aadhaar_no', $request->aadhaar_no)->first();
                    if ($request->hasFile('video')) {
                        $video = $request->file('video');
                        $filename = time() . '_' . $video->getClientOriginalName();
                        $uploadDirectory = 'uploads/';
                        $video->move($uploadDirectory, $filename);
                    
                        if (!empty($personalDetail->live_video)) {
                            $previousVideoPath = public_path($uploadDirectory . $personalDetail->live_video);
                            if (File::exists($previousVideoPath)) {
                                unlink($previousVideoPath);
                            }
                        }
                    
                        // Update the record with the new video information
                        DB::table('personal_detail')
                            ->where('aadhaar_no', $request->aadhaar_no)
                            ->update([
                                'live_video' => $filename,
                                'unique_no' => $request->randomNo
                            ]);
                    
                        return response()->json(['success' => true, 'message' => 'Video saved successfully']);
                   }
               
        } catch (Exception $e) {
                 return response()->json(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
        }
  }
  

//   public function saveVideo(Request $request)
//   {
//         try {
    
//             $personalDetail = PersonalDetail::where('aadhaar_no', $request->aadhaar_no)->first();
//                     if ($request->hasFile('video')) {
//                             $video = $request->file('video');
//                             $extension=$video->getClientOriginalName();
//                             $filename= time() .'_'.$extension;
//                             $video->move('uploads/', $filename);
//                             // Update the record
//                             $personalDetail->live_video = $filename;
//                             $personalDetail->unique_no = $request->randomNo;
//                             $personalDetail->save();

//                           return response()->json(['success' => true, 'message' => 'Video saved successfully']);
//                     } 
               
//         } catch (Exception $e) {
//                  return response()->json(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
//         }
//   }


   public function previewVideo(Request $request)
    {
        $aadharNumber = $request->session()->get('aadhaar_no');
        $user = DB::table('personal_detail')->where('aadhaar_no', $aadharNumber)->first();
        return view('pages.preview',compact('aadharNumber','user'));
    }


    public function getVideoData(Request $request)
    {

        $video = PersonalDetail::where('aadhaar_no',$request->aadhaar_no)->first();
        if ($video) {
            return response()->json(['video_path' => $video->live_video]);
        }
        return response()->json(['error' => 'Video not found'], 404);
    }








}






