<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
//scientific notation
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
//headings
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class PersonalDetail extends Model implements  FromCollection, WithHeadings, WithMapping, WithColumnFormatting,WithStyles
{
    use HasFactory;
    public $guarded=[""];
    protected $table='personal_detail';
    // protected $primaryKey='personal_detail_id';
    
    public function collection()
    {
     return PersonalDetail::all();
    }
    
    public function headings(): array
    {
        return [
            'Verification Code',
            'First Name',
            'Middle Name',
            'Last Name',
            'Email',
            'Mobile No',
            'Gender',
            'Date of birth',
            'Address',
            'Aadhaar no',
            'Retirement date',
            'Live Photo'
        ];
    }
   
   public function map($personaldetail): array
    {
        return [
            $personaldetail->unique_no,
            $personaldetail->first_name,
            $personaldetail->middle_name,
            $personaldetail->last_name,
            $personaldetail->email,
            $personaldetail->mobile_no,
            $personaldetail->gender,
            $personaldetail->date_of_birth,
            $personaldetail->address,
            $personaldetail->aadhaar_no,
            $personaldetail->retirement_date,
            'Website' => '=HYPERLINK("' . url('/') . '/uploads/documents/' . $personaldetail->live_photo . '", "View Photo")',
        ];
    }
    
    public function columnFormats(): array
     {
        return [
            'J' =>  NumberFormat::FORMAT_NUMBER, // Format for Aadhar number column
        ];
     }
     
      public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]], 
        ];
    }

   

    
}
